document.addEventListener("DOMContentLoaded", function () {
    const coin1 = document.getElementById('coin_1');
    const coin2 = document.getElementById('coin_2');
    const coin3 = document.getElementById('coin_3');
    const coin4 = document.getElementById('coin_4');
    const body = document.body;

    let mouseX = 0;
    let mouseY = 0;
    let windowCenterX = window.innerWidth / 2;
    let windowCenterY = window.innerHeight / 2;

    let animationFrameId = null;
    let isAnimating = false;
    let inactivityTimeout = null;

    function updateWindowCenter() {
        windowCenterX = window.innerWidth / 2;
        windowCenterY = window.innerHeight / 2;
    }

    function handleMouseMove(e) {
        mouseX = e.clientX - windowCenterX;
        mouseY = e.clientY - windowCenterY;

        startAnimation();

        clearTimeout(inactivityTimeout);
        inactivityTimeout = setTimeout(stopAnimation, 200);
    }

    function animate() {
        const x1 = mouseX / 25;
        const x2 = mouseY / 60;
        const x3 = mouseX / 30;
        const x4 = mouseY / 40;


        const x5 = mouseX / 10;
        const x6 = mouseY / 20;
        const x7 = mouseX / 10;
        const x8 = mouseY / 20;

        if (body.offsetWidth > 800 && body.offsetHeight > 600) {
            coin1.style.transform = `translate(${-x5}px, ${-x6}px)`;
            coin2.style.transform = `translate(${x7}px, ${x8}px)`;

            coin3.style.transform = `translate(${-x1}px, ${-x2}px)`;
            coin4.style.transform = `translate(${x3}px, ${x4}px)`;
        }

        animationFrameId = requestAnimationFrame(animate);
    }

    function startAnimation() {
        if (!isAnimating) {
            isAnimating = true;
            animate();
        }
    }

    function stopAnimation() {
        if (isAnimating) {
            cancelAnimationFrame(animationFrameId);
            isAnimating = false;
        }
    }

    body.addEventListener('mousemove', handleMouseMove);
    window.addEventListener('resize', updateWindowCenter);
});
