document.addEventListener("DOMContentLoaded", function () {
    getDomain();
});

function getDomain() {
    fetch('domain.txt')
        .then(response => response.text())
        .then(domain => {
            if (domain.length === 0) {
                console.error('Domain is empty');
                return;
            }

            domain = domain.trim();

            if (!domain.includes('https://')) {
                console.error('Domain should contain https://');
                return;
            }

            const params = new URLSearchParams(window.location.search);

            if (!params) {
                console.error('Url params error');
                return;
            }

            const link = domain + '?' + params;

            setLinkToBtn(link);
        })
        .catch(err => console.error('Failed to load domain file:', err));
}

function setLinkToBtn(link) {
    const buttons = document.querySelectorAll( '.redirect_btn');

    if (!buttons.length) {
        return;
    }

    buttons.forEach(btn => {
        btn.href = link;
    });
}
